//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "GLWektory.h"
#include "Teksturowanie.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TGLForm(Owner)
{
   KolorTla=clBlack;
   debug_mode=false;
   Mgla=false;
   NieruchomyPokoj=false;

   NatezenieSwiatlaOtoczenia=0.5f;
   Obracaj(10.0f,1.0f,0.0f);

   //teksturowanie
   glEnable(GL_TEXTURE_2D);

	int TeksturaSzer,TeksturaWys;
	unsigned long* Tekstura=WczytajTeksture("tekstura.bmp",TeksturaSzer,TeksturaWys);
	if (Tekstura!=NULL)
	{
		glBindTexture(GL_TEXTURE_2D,Tekstura[0]);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		gluBuild2DMipmaps(GL_TEXTURE_2D,3,TeksturaSzer,TeksturaWys,GL_RGBA,GL_UNSIGNED_BYTE,Tekstura);
		delete[] Tekstura; //oryginalne dane sa usuwane
	}
}

//---------------------------------------------------------------------------

void __fastcall TForm1::RysujScene()
{
   int GL_LIGHT_MODEL_COLOR_CONTROL=0x81F8,
   GL_SINGLE_COLOR=0x81F9,GL_COLOR_SIMPLE=0x81F9,
   GL_SEPARATE_SPECULAR_COLOR=0x81FA;

   const float wsp_odbicia_szklo[4]={1.0,1.0,1.0,1.0};
   const float wsp_odbicia_matowy[4]={0.0,0.0,0.0,1.0};

   glMaterialfv(GL_FRONT,GL_SPECULAR,wsp_odbicia_szklo);
   glMateriali(GL_FRONT,GL_SHININESS,100);
   glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL,GL_SEPARATE_SPECULAR_COLOR); //konieczne, aby tekstury nie psuly

   glColor4ub(255,255,255,255);
   RysujSzescian(1.0f);

   glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL,GL_SINGLE_COLOR);
   glMaterialfv(GL_FRONT,GL_SPECULAR,wsp_odbicia_matowy);
   glMateriali(GL_FRONT,GL_SHININESS,0);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::RysujOstroslup(float x0,float y0,float z0) const
{
   const bool kolory=true;

   //Rysowanie trojkata
   glBegin(GL_TRIANGLES);
   //ustalanie trzech wierzcholkow trojkata (werteksow (x,y,z))
   //(0,0,z) jest mniej wiecej w srodku ekranu

   //tylna
   if(kolory) glColor3ub(255,255,0); //zolty
   glNormal3f(0,0,-1.0); //w glab
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, y0, z0); //gorny

   //podstawa
   if(kolory) glColor3ub(0,255,0); //zielony
   glNormal3f(0,-1.0,0); //do dolu
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, -y0, 2*z0); //dolny przedni

   //lewa
   if(kolory) glColor3ub(255,0,0); //czerwony
   float punktL1[3]={-x0,-y0,z0};
   float punktL2[3]={0,-y0,2*z0};
   float punktL3[3]={0,y0,z0};
   float normalnaL[3];
   JednostkowyWektorNormalny3fv(punktL1,punktL2,punktL3,normalnaL);
   glNormal3fv(normalnaL);
   glVertex3fv(punktL1); //dolny lewy
   glVertex3fv(punktL2); //dolny przedni
   glVertex3fv(punktL3); //gorny

   //prawa
   if(kolory) glColor3ub(0,0,255); //niebieski
   float punktR1[3]={x0, -y0, z0}; //dolny prawy
   float punktR2[3]={0, -y0, 2*z0}; //dolny przedni
   float punktR3[3]={0, y0, z0}; //gorny
   //odwrocone - aby nawijanie bylo prawidlowe (przy def. trojkata tez zmiana kolejnosci)
   float normalnaR[3];
   JednostkowyWektorNormalny3fv(punktR1,punktR3,punktR2,normalnaR);
   glNormal3fv(normalnaR);
   glVertex3fv(punktR1); //dolny lewy
   glVertex3fv(punktR3); //dolny przedni
   glVertex3fv(punktR2); //gorny

   //koniec rysowania figury
   glEnd();
}

void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   //obroty
   if (Shift.Empty())
   {
      if (Key>='0' && Key<='7')
      {
         GLenum swiatlo=GL_LIGHT0;
         switch (Key)
         {
            case '1': swiatlo=GL_LIGHT1; break;
            case '2': swiatlo=GL_LIGHT2; break;
            case '3': swiatlo=GL_LIGHT3; break;
            case '4': swiatlo=GL_LIGHT4; break;
            case '5': swiatlo=GL_LIGHT5; break;
            case '6': swiatlo=GL_LIGHT6; break;
            case '7': swiatlo=GL_LIGHT7; break;
            default: swiatlo=GL_LIGHT0;
         }
         if (glIsEnabled(swiatlo)) glDisable(swiatlo);
         else glEnable(swiatlo);
      }

      switch (Key)
      {
         case 'b':
         case 'B':
            if (glIsEnabled(GL_BLEND)) glDisable(GL_BLEND);
            else glEnable(GL_BLEND);
            break;
         case 'a':
         case 'A':
            if (glIsEnabled(GL_POINT_SMOOTH))
            {
               glDisable(GL_POINT_SMOOTH);
               glDisable(GL_LINE_SMOOTH);
               glDisable(GL_POLYGON_SMOOTH);
            }
            else
            {
               glEnable(GL_POINT_SMOOTH);
               glEnable(GL_LINE_SMOOTH);
               glEnable(GL_POLYGON_SMOOTH);
            }
            break;

         case 'm':
         case 'M':
            Mgla=!Mgla;
            break;

         case 'n':
         case 'N':
            NieruchomyPokoj=!NieruchomyPokoj;
            break;

         case 't':
         case 'T':
            if (glIsEnabled(GL_TEXTURE_2D)) glDisable(GL_TEXTURE_2D);
            else glEnable(GL_TEXTURE_2D);
            break;


         case VK_OEM_MINUS:
            NatezenieSwiatlaOtoczenia-=0.01;
            break;
         case VK_OEM_PLUS:
         case '=':
            NatezenieSwiatlaOtoczenia+=0.01;
            break;
      }
   }

   GL_RysujScene();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::RysujSzescian(float krawedz) const
{
	const float a=krawedz;

	glBegin(GL_QUADS);
	//tylnia
   glNormal3f(0,0,-1); //wektory normalne skierowane na zewnatrz
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,-a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(-a,a,-a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(a,-a,-a);
	//przednia
   glNormal3f(0,0,1);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-a,a,a);

	//prawa
   glNormal3f(1,0,0);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(a,-a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(a,-a,-a);
	//lewa
   glNormal3f(-1,0,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(-a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,-a);

	//gorna
   glNormal3f(0,1,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,a,-a);
	//dolna
   glNormal3f(0,-1,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,-a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,-a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,-a);
	//

	glEnd();
}

void __fastcall TForm1::RysujSzescian_Okno(float krawedz,TColor kolor) const
{
	const float a=krawedz;
   int R=GetRValue(kolor);
   int G=GetGValue(kolor);
   int B=GetBValue(kolor);
   glColor4ub(R,G,B,255);

	glBegin(GL_QUADS);
	//tylnia
   glNormal3f(0,0,-1); //wektory normalne skierowane na zewnatrz
	glVertex3f(-a,-a,-a);
	glVertex3f(-a,a,-a);
	glVertex3f(a,a,-a);
	glVertex3f(a,-a,-a);
	//przednia
   glNormal3f(0,0,1);
	glVertex3f(-a,-a,a);
	glVertex3f(a,-a,a);
	glVertex3f(a,a,a);
	glVertex3f(-a,a,a);

	//prawa
   glNormal3f(1,0,0);
	glVertex3f(a,-a,a);
	glVertex3f(a,a,a);
	glVertex3f(a,a,-a);
	glVertex3f(a,-a,-a);
	//lewa
   glNormal3f(-1,0,0);
	glVertex3f(-a,-a,a);
	glVertex3f(-a,a,a);
	glVertex3f(-a,a,-a);
	glVertex3f(-a,-a,-a);

	//gorna
   glNormal3f(0,1,0);
	glVertex3f(-a,a,a);
	glVertex3f(a,a,a);
	glVertex3f(a,a,-a);
	glVertex3f(-a,a,-a);
	//dolna
   glColor4ub(R,G,B,127);
   glNormal3f(0,-1,0);
	glVertex3f(-a,-a,a);
	glVertex3f(a,-a,a);
	glVertex3f(a,-a,-a);
	glVertex3f(-a,-a,-a);
   glColor4ub(R,G,B,255);
	//

	glEnd();
}

void __fastcall TForm1::RysujSzescian_UsrednianieNormalnych(float krawedz) const
{
	const float a=krawedz;

	glBegin(GL_QUADS);
	//tylnia
	glNormal3f(-1,-1,-1); glVertex3f(-a,-a,-a);
	glNormal3f(-1,1,-1); glVertex3f(-a,a,-a);
	glNormal3f(1,1,-1); glVertex3f(a,a,-a);
	glNormal3f(1,-1,-1); glVertex3f(a,-a,-a);
	//przednia
	glNormal3f(-1,-1,1); glVertex3f(-a,-a,a);
	glNormal3f(1,-1,1); glVertex3f(a,-a,a);
	glNormal3f(1,1,1); glVertex3f(a,a,a);
	glNormal3f(-1,1,1); glVertex3f(-a,a,a);

	//prawa
	glNormal3f(1,-1,1); glVertex3f(a,-a,a);
	glNormal3f(1,1,1); glVertex3f(a,a,a);
	glNormal3f(1,1,-1); glVertex3f(a,a,-a);
	glNormal3f(1,-1,-1); glVertex3f(a,-a,-a);
	//lewa
	glNormal3f(-1,-1,1); glVertex3f(-a,-a,a);
	glNormal3f(-1,1,1); glVertex3f(-a,a,a);
	glNormal3f(-1,1,-1); glVertex3f(-a,a,-a);
	glNormal3f(-1,-1,-1); glVertex3f(-a,-a,-a);

	//gorna
	glNormal3f(-1,1,1); glVertex3f(-a,a,a);
	glNormal3f(1,1,1); glVertex3f(a,a,a);
	glNormal3f(1,1,-1); glVertex3f(a,a,-a);
	glNormal3f(-1,1,-1); glVertex3f(-a,a,-a);
	//dolna
	glNormal3f(-1,-1,1); glVertex3f(-a,-a,a);
	glNormal3f(1,-1,1); glVertex3f(a,-a,a);
	glNormal3f(1,-1,-1); glVertex3f(a,-a,-a);
	glNormal3f(-1,-1,-1); glVertex3f(-a,-a,-a);
	//

	glEnd();
}

void __fastcall TForm1::Oswietlenie()
{
   MlecznaZarowka();
   //ZoltaIZielonaMleczneZarowki();
   Reflektor();
}

void __fastcall TForm1::MlecznaZarowka()
{
   const float kolor1_rozproszone[]={0.5,0.5,0.5,1.0};
   glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor1_rozproszone);
   glEnable(GL_LIGHT1);
}

void __fastcall TForm1::ZoltaIZielonaMleczneZarowki()
{
   //zolta mleczna zarowka
	const float kolor_rozproszone_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};

	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_rozproszone_zolta);
	glEnable(GL_LIGHT2);

   //zielona mleczna zarowka
	const float kolor_rozproszone_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};

	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_rozproszone_zielony);
	glEnable(GL_LIGHT3);
}

void __fastcall TForm1::Reflektor()
{
   const float kolor_rozproszone[4]={0.3,0.3,0.3,1.0};
   const float kolor_reflektora[4]={1.0,1.0,1.0,1.0};
   const float pozycja[4]={0.0,-10.0,10.0,1.0};
   //const float pozycja[4]={2.0f,2.0f,-2.0f,1.0f};
   const szerokosc_wiazki=60.0; //w stopniach
   glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
   glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);
   glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_reflektora);
   glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
   glEnable(GL_LIGHT4);
}

void __fastcall TForm1::Pomoc()
{
	AnsiString s=(AnsiString)"GLForm 1.1\n(c) Jacek Matulewski 2006-2007\n\n"+
			"OpenGL, wersja "+(char*)glGetString(GL_VERSION)+"\n"+
			"GLU, wersja "+(char*)gluGetString(GLU_VERSION);
   s+="\n\n+/- - Jasno wiata otoczenia\nstrzaki - ruch obiektu\n\nQ - Animacja\nB - Alpha blending\nA - Antyaliasing\m - Mga\nN - Nieruchomy pokj";
	MessageBox(Handle,s.c_str(),"TGLForm",MB_OK | MB_ICONINFORMATION);
}

